package {
	
	import away3d.arcane;
	import away3d.containers.ObjectContainer3D;
	import away3d.core.base.Face;
	import away3d.core.base.Mesh;
	import away3d.core.base.Object3D;
	import away3d.core.base.Vertex;
	import away3d.core.draw.DrawTriangle;
	import away3d.core.draw.ScreenVertex;
	import away3d.core.math.Number3D;
	import away3d.core.project.MeshProjector;
	import away3d.core.utils.Debug;
	import away3d.core.utils.FaceVO;
	import away3d.events.LoaderEvent;
	import away3d.lights.DirectionalLight3D;
	import away3d.loaders.Collada;
	import away3d.loaders.Object3DLoader;
	import away3d.loaders.data.MaterialData;
	import away3d.materials.BitmapMaterial;
	import away3d.materials.ColorMaterial;
	import away3d.materials.IMaterial;
	import away3d.materials.PhongColorMaterial;
	import away3d.materials.ShadingColorMaterial;
	import away3d.materials.WhiteShadingBitmapMaterial;
	import away3d.materials.WireColorMaterial;
	import away3d.materials.WireframeMaterial;
	import away3d.primitives.Cube;
	
	import com.flashdynamix.motion.Tweensy;
	import com.flashdynamix.motion.TweensyTimeline;
	
	import fl.motion.easing.Cubic;
	import fl.motion.easing.Linear;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.filters.ColorMatrixFilter;
	import flash.system.System;
	import flash.utils.Dictionary;
	import flash.utils.getTimer;
	
	import frocessing.color.ColorHSV;
	
	import net.saqoosha.geom.Point3D;
	import net.saqoosha.util.ColorUtil;
	
	import org.libspark.thread.Monitor;
	import org.libspark.thread.Thread;
	import org.libspark.thread.utils.EventDispatcherThread;

	public class HoleDemo extends EventDispatcherThread implements IDemoThread {
		
		private static const GLOBAL_DRAG:Number = 0.99;
		private static const GRABITY:Number = 0.8;
		
		private var _ctx:Context;
		private var _hole:Object3DLoader;
		private var _depth:Number;
		private var _inner:Mesh;
		private var _dummy:Mesh;
		private var _outer:Mesh;
//		private var _bezier:CubicBezierLine3D;
//		private var _flyoutline:FlyOutLine;
//		private var _dummyLookupTable:Dictionary = new Dictionary();
//		private var _markerMat:BitmapMaterial;
		private var _anime:TweensyTimeline;
		private var _pcubes:Array = [];
		private var _monitor:Monitor;
		
		public function HoleDemo(ctx:Context) {
			this._ctx = ctx;
		}
		
		protected override function run():void {
			Debug.active = true;
			this._hole = Collada.load('models/untitled.dae');
			this._hole.scale(0.1);
			this._ctx.arview.marker.addChild(this._hole);
			event(this._hole, LoaderEvent.LOAD_SUCCESS, this._onLoaded);
		}
		
		private function _onLoaded(e:Event):void {
			var f:Face;
			for each (var mesh:Mesh in ObjectContainer3D(this._hole.handle).children) {
				trace(mesh.name);
				switch (mesh.name) {
					case 'Outer':
						this._outer = mesh;
						var mat:ColorMaterial = new ColorMaterial(0x00ff00);
//						var mat:ShadingColorMaterial = new ShadingColorMaterial(0xaa0000);
//						var mat:PhongColorMaterial = new PhongColorMaterial(0xaa0000);
						for each (f in mesh.faces) {
							f.material = mat;
						}
						break;
					case 'Inner':
						this._inner = mesh;
//						var data:MaterialData = this._hole.materialLibrary.getMaterial('marker_png_001');
//						this._markerMat = BitmapMaterial(data.material);
//						this._markerMat.bitmap = this._ctx.arview.captureImage.bitmapData;
						break;
					case 'Dummy':
						this._dummy = mesh;
						var nomat:NoMaterial = new NoMaterial();
//						var nomat:ColorMaterial = new ColorMaterial(0x0000ff, {alpha:0.5});
//						var nomat:BitmapMaterial = new BitmapMaterial(this._ctx.arview.captureImage.bitmapData, {alpha:0.3});
						for each (f in mesh.faces) {
							f.material = nomat;
						}
						break;
				}
			}

			for each (var v:Vertex in this._inner.vertices) {
				v.extra = v.z;
			}

//			var n:int = this._dummy.faces.length;
//			for (var i:int = 0; i < n; i++) {
//				var f1:Face = this._dummy.faces[i];
//				var f2:Face = this._inner.faces[i];
//				this._dummyLookupTable[f2] = f1;
//			}

			this._ctx.arview.filters = [
				new ColorMatrixFilter([
					1,  0, 0, 0, 0,
					0,  1, 0, 0, 0,
					0,  0, 1, 0, 0,
					1, -1, 1, 1, 0
				])
			];
			
			this.depth = 0;
//			this._anime.repeatType = TweensyTimeline.YOYO;
//			this._anime.repeatCount = 0;
			
//			this._bezier = new CubicBezierLine3D(new Point3D(0, 0, 0), new Point3D(10, 0, 0), new Point3D(20, 0, 0), new Point3D(30, 0, 0));
//			this._ctx.arview.marker.addChild(this._bezier);

//			this._flyoutline = new FlyOutLine(this._ctx.arview.marker);
//			this._ctx.arview.scene.addChild(this._flyoutline);
			
//			this._ctx.arview.addEventListener('preRender', this._onPreRender);

			this._monitor = new Monitor();
			this._monitor.wait();
			this._anime = Tweensy.fromTo(this, {depth:0}, {depth:-150}, 2, Linear.easeNone, 1);
			this._anime.onComplete = this._monitor.notifyAll;
			next(this._onAnimeDone);
		}
		
		private function _onAnimeDone():void {
			trace('_onAnimeDone');
			this._monitor = null;
			next(this._update);
		}
		
		private function _update():void {
			if (checkInterrupted()) {
				return;
			}
			var c:PCube;
			if (Math.random() < 0.5 && this._ctx.arview.detected) {
				var col:int = new ColorHSV((getTimer() % 10000 + Math.random() * 2000) / 10000 * 360, 1, 1).value;
				var mat:IMaterial;
				if (Math.random() < 0.8) {
					mat = new WhiteShadingBitmapMaterial(new BitmapData(1, 1, false, col));
				} else {
					mat = new WireframeMaterial(col);
				}
				c = new PCube({width:10, height:10, depth:10, material:mat});
				c.scale(0.3);
				c.rotationX = Math.random() * 360;
				c.rotationY = Math.random() * 360;
				c.rotationZ = Math.random() * 360;
				var marker:Object3D = this._ctx.arview.marker;
				var p1:Number3D = Away3DMathUtil.multiplyMatri3DNumber3D(marker.transform, new Number3D(0, -60, 0));
				c.x = p1.x;
				c.y = p1.y;
				c.z = p1.z;
				var p2:Number3D = Away3DMathUtil.multiplyMatri3DNumber3D(marker.transform, new Number3D((Math.random() - 0.5) * 3, -45, (Math.random() - 0.5) * 3));
				c.velocity = new Number3D(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
				this._ctx.arview.scene.addChild(c);
				this._pcubes.push(c);
				var s:Number = 0.7 + Math.random();
				Tweensy.to(c, {scaleX:s, scaleY:s, scaleZ:s}, 0.3, Cubic.easeIn);
				Tweensy.to(c, {rotationX:Math.random() * 360, rotationY:Math.random() * 360, rotationZ:Math.random() * 360}, 1, Linear.easeNone);
			}
			var n:int = this._pcubes.length;
			while (n--) {
				c = this._pcubes[n];
				c.velocity.x *= GLOBAL_DRAG;
				c.velocity.y -= GRABITY;
				c.velocity.y *= GLOBAL_DRAG;
				c.velocity.z *= GLOBAL_DRAG;
				c.x += c.velocity.x;
				c.y += c.velocity.y;
				c.z += c.velocity.z;
				if (c.y < -200) {
					if (c.material is WhiteShadingBitmapMaterial) {
						WhiteShadingBitmapMaterial(c.material).bitmap.dispose();
					}
					this._ctx.arview.scene.removeChild(c);
					this._pcubes.splice(n, 1);
				}
			}
			next(this._update);
		}
		
//		private function _onPreRender(e:Event):void {
//			var mp:MeshProjector = this._ctx.arview.arcane::_meshProjector;
//			if (!mp.getPrimitive(this._dummy.faces[0])) {
//				return;
//			}
//			var f:Face;
//			var n:int = this._dummy.faces.length;
//			for (var i:int = 0; i < n; i++) {
//				var f1:Face = this._dummy.faces[i];
//				var f2:Face = this._inner.faces[i];
//				var dt:DrawTriangle = mp.getPrimitive(f1) as DrawTriangle;
//				f2.uv0.u = (dt.v0.x + 160 - 2.5) / 320;
//				f2.uv0.v = 1 - (dt.v0.y + 120) / 240;
//				f2.uv1.u = (dt.v1.x + 160 - 2.5) / 320;
//				f2.uv1.v = 1 - (dt.v1.y + 120) / 240;
//				f2.uv2.u = (dt.v2.x + 160 - 2.5) / 320;
//				f2.uv2.v = 1 - (dt.v2.y + 120) / 240;
//				var vo:FaceVO = this._markerMat.getFaceVO(f1, null);
//				vo.texturemapping = null;
//			}
////			if (this._dummy) {
////				trace(this._dummy.name);
////				for each (f in this._dummy.faces) {
////					var dt:DrawTriangle = mp.getPrimitive(f) as DrawTriangle;
////					if (dt)
////						trace(f, dt.v0);
////				}
////			}
////			trace(this._outer.name);
////			for each (f in this._outer.faces) {
////				trace(f.v0, mp.getScreenVertex(f.v0));
////			}
//			this._markerMat.bitmap = this._markerMat.bitmap;
//		}

		public function get depth():Number {
			return this._depth;
		}
		
		public function set depth(value:Number):void {
			this._depth = value;
			for each (var v:Vertex in this._inner.vertices) {
				var min:Number = Number(v.extra);
				v.z = value < min ? min : value;
			}
		}
		
		public function close():void {
			if (this._monitor) {
				this._monitor.notifyAll();
				this._monitor = null;
				this._anime.stopAll();
				this._anime = null;
//				this._ctx.arview.removeEventListener('preRender', this._onPreRender);
			} else {
				this.interrupt();
			}
		}
		
		private function _cleanup():void {
			
		}
		
		protected override function finalize():void {
			trace('finalize', this);
			for each (var c:PCube in this._pcubes) {
				this._ctx.arview.scene.removeChild(c);
			}
			this._pcubes = null;
			this._ctx.arview.marker.removeChild(this._hole.handle);
			this._ctx.arview.filters = [];
			this._ctx = null;
			this._hole = null;
			this._inner = null;
			this._outer = null;
			this._dummy = null;
//			this._dummyLookupTable = null;
//			this._markerMat = null;
			System.gc();
		}
	}
}


import away3d.primitives.Cube;
import away3d.core.math.Number3D;

class PCube extends Cube {
	
	public var velocity:Number3D;
	
	public function PCube(init:Object = null) {
		super(init);
	}
}